/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.items.trinkets;

import com.glisco.things.Things;
import com.glisco.things.client.ThingsClient;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.items.TrinketItemWithOptionalTooltip;
import com.glisco.things.misc.SockDataComponent;
import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import io.wispforest.owo.ops.TextOps;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9331;

public class SocksItem
extends TrinketItemWithOptionalTooltip {
    public static final class_9331<Integer> SPEED = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)Things.id("socks_speed"), (Object)class_9331.method_57873().method_57881((Codec)Codec.INT).method_57882(class_9135.field_48550).method_57880());
    public static final class_9331<Boolean> JUMPY_AND_ENABLED = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)Things.id("jumpy_and_enabled"), (Object)class_9331.method_57873().method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547).method_57880());

    public SocksItem() {
        super(new OwoItemSettings().maxCount(1).group(Things.THINGS_GROUP).method_57349(SPEED, (Object)0));
    }

    public static class_1799 create(int speed, boolean jumpy) {
        class_1799 stack = new class_1799((class_1935)ThingsItems.SOCKS);
        stack.method_57379(SPEED, (Object)speed);
        if (jumpy) {
            stack.method_57379(JUMPY_AND_ENABLED, (Object)true);
        }
        return stack;
    }

    public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        if (!stack.method_57826(JUMPY_AND_ENABLED)) {
            return;
        }
        builder.addExclusive(class_5134.field_47761, new class_1322(Things.id("socks.step_height"), 0.45, class_1322.class_1323.field_6328));
    }

    public void tick(class_1799 stack, SlotReference reference) {
        class_1309 class_13092 = reference.entity();
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        SockDataComponent sockData = (SockDataComponent)Things.SOCK_DATA.get((Object)player);
        sockData.jumpySocksEquipped = stack.method_57826(JUMPY_AND_ENABLED);
        if (player.method_37908().field_9236) {
            return;
        }
        sockData.updateSockSpeed(reference.slot(), (Integer)stack.method_57824(SPEED) + 1);
        if (!sockData.jumpySocksEquipped || !((Boolean)stack.method_57825(JUMPY_AND_ENABLED, (Object)true)).booleanValue()) {
            return;
        }
        player.method_6092(new class_1293(class_1294.field_5913, 5, 1, true, false, true));
    }

    public void onUnequip(class_1799 stack, SlotReference reference) {
        class_1309 entity = reference.entity();
        ((SockDataComponent)Things.SOCK_DATA.get((Object)entity)).jumpySocksEquipped = false;
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        int speed = (Integer)stack.method_57824(SPEED);
        ((SockDataComponent)Things.SOCK_DATA.get((Object)player)).modifySpeed(-Things.CONFIG.sockPerLevelSpeedAmplifier() * (float)(speed + 1));
        ((SockDataComponent)Things.SOCK_DATA.get((Object)player)).clearSockSpeed(reference.slot());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void append(List<class_2561> tooltip) {
        this.appendWrapped(tooltip, (class_2561)class_2561.method_43469((String)this.tooltipTranslationKey(), (Object[])new Object[]{KeyBindingHelper.getBoundKeyOf((class_304)ThingsClient.TOGGLE_SOCKS_JUMP_BOOST).method_27445()}));
    }

    @Override
    public void getExtraTooltip(class_1799 stack, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        int speed;
        ArrayList<class_5250> extraTooltips = new ArrayList<class_5250>();
        this.tryAppend(extraTooltips);
        if (stack.method_57826(JUMPY_AND_ENABLED)) {
            extraTooltips.add(TextOps.withColor((String)"\u2191 ", (int)((Boolean)stack.method_57824(JUMPY_AND_ENABLED) == false ? TextOps.color((class_124)class_124.field_1080) : 3462300)).method_10852((class_2561)TextOps.translateWithColor((String)"item.things.socks.jumpy", (int)TextOps.color((class_124)class_124.field_1080))));
        }
        if ((speed = ((Integer)stack.method_57824(SPEED)).intValue()) < 3) {
            extraTooltips.add(TextOps.withColor((String)"\u2604 ", (int)3453396).method_10852((class_2561)TextOps.translateWithColor((String)("item.things.socks.speed_" + speed), (int)TextOps.color((class_124)class_124.field_1080))));
        } else {
            extraTooltips.add(TextOps.withColor((String)"\u2604 ", (int)3453396).method_10852((class_2561)TextOps.translateWithColor((String)"item.things.socks.speed_illegal", (int)TextOps.color((class_124)class_124.field_1061))).method_10852((class_2561)TextOps.withColor((String)(" (" + speed + ")"), (int)TextOps.color((class_124)class_124.field_1061))));
        }
        extraTooltips.add(class_2561.method_43470((String)" "));
        tooltips.addAll(0, extraTooltips);
    }
}

